const express = require('express');
const bodyParser = require('body-parser');
const crypto = require("crypto");

const app = express();
const port = 9999;

function verifySignature(request, secret) {
    const hashedBody = crypto.createHash('sha256').update(Buffer.from(JSON.stringify(request.body))).digest('hex')
    if(hashedBody !== request.headers['x-webhook-hashed-body']){
        return false
    }

    const path = request.path
    const hmac = crypto.createHmac('SHA256', secret);
    hmac.update(request.headers['x-webhook-timestamp'] + path + request.headers['x-webhook-nonce'] + request.headers['x-webhook-hashed-body']);
    const signature = hmac.digest( 'hex' )

    if(signature !== request.headers['x-webhook-signature']){
        return false
    }
    return true
}

app.use(bodyParser.json());

app.get('/', (req, res) => {
    return res.status(200).send('Welcome! I am ready to receive!');
});

app.post('/', (req, res) => {
    if (typeof req.body === 'undefined' || typeof req.body.id === 'undefined' || typeof req.body.type === 'undefined' || typeof req.body.attempt === 'undefined' || typeof req.body.created === 'undefined' || typeof req.body.data === 'undefined') {
        return res.status(400).send('req.body is missing or data is incorrect.');
    }

    // Event is incoming!
    console.log('Event incoming!');

    if (req.body.attempt > 1) {
        // This webhook was failed earlier, some notification can be sent to the administrator as warning.
        console.log("Attempt is higher than 1, sending warning to administrator.")
    }

    console.log(req.headers)
    // Do something with incoming data based on different event types as described in README file.
    console.log('ID: ' + req.body.id);
    console.log('Type: ' + req.body.type);
    console.log('Attempt: ' + req.body.attempt);
    console.log('Created: ' + req.body.created);
    console.log('HMAC timestamp: ' + req.headers['x-webhook-timestamp'])
    console.log('HMAC signature: ' + req.headers['x-webhook-signature'])
    console.log('HMAC nonce: ' + req.headers['x-webhook-nonce'])
    console.log('HMAC hashed body: ' + req.headers['x-webhook-hashed-body'])
    if(req.headers['x-webhook-signature']) {
        const isSignatureValid = verifySignature(req, 'Test12344321Test')
        console.log('HMAC signature valid: ', isSignatureValid)
    }
    console.log('Data:');
    console.log(req.body.data);



    // Let the webhook sender know that the webhook is received correctly.
    return res.status(200).send('OK');
});

app.listen(port, () => {
    console.log('Webhooks receiver app listening at http://localhost:' + port);
});