# Webhooks

Using webhooks make it possible to pick up events real-time. The `webhook_url` can be provided on the required level(s). The 'type' and the response data will be sent to the specified `webhook_url`. Events get triggered in the API and in the admin portal. It's required to have your receiving HTTP server running on SSL to keep all data secure.

## Webhook URL
The `webhook_url` can be provided on 4 different levels. All levels will receive events from lower levels only.

| Level    | Receive events from                           |
|----------|-----------------------------------------------|
| Reseller | Dealers, companies, users, sites and meetings |
| Dealer   | Companies, users, sites and meetings          |
| Company  | Users, sites and meetings                     |
| Site     | Meetings                                      |

When a `webhook_url` is configured on 'company' and 'site' level for example, they both receive events about meetings, but only 'company' level will receive events about users and sites.

## Types

Types will specify which event get triggered.

| Type              | Event                                 |
|-------------------|---------------------------------------|
| MEETING_CREATED   | Meeting created                       |
| MEETING_STARTED   | Meeting start                         |
| MEETING_RESTARTED | Meeting restart                         |
| MEETING_ENDED     | Meeting end                           |
| MEETING_CHANGED   | Meeting changed                       |
| MEETING_TAKEOVER  | Meeting taken by another agent        |
| MEETING_WAIT      | Meeting agent set participant in wait |
| MEETING_DECLINED  | Meeting call declined by agent        |
| MEETING_FORWARDED | Meeting forwarded to another agent    |
| MEETING_DELETED   | Meeting deleted                       |
| USER_CREATED      | User created                          |
| USER_CHANGED      | User changed                          |
| USER_DELETED      | User deleted                          |
| SITE_CREATED      | Site created                          |
| SITE_CHANGED      | Site changed                          |
| SITE_DELETED      | Site deleted                          |
| COMPANY_CREATED   | Company created                       |
| COMPANY_CHANGED   | Company changed                       |
| COMPANY_DELETED   | Company deleted                       |
| DEALER_CREATED    | Dealer created                        |
| DEALER_CHANGED    | Dealer changed                        |
| DEALER_DELETED    | Dealer deleted                        |

## Response status

Only response code 200 will be accepted. All other response codes will be marked as failed.

## Attempts

When the response code is not 200, the webhook will be sent again with a maximum of 5 attempts.

When 5 attempts reached, a error notification email will be sent to `notification_contact` email field including any received error messages.

**Note:** after a webhook is created, it will use the `webhook_url` which was configured before the webhook was created. Changing the `webhook_url` will only affect new webhook triggers.

| Attempt | Trigger                       |
|---------|-------------------------------|
| 1       | Directly after event happened |
| 2       | After 1 minute                |
| 3       | After 10 minutes              |
| 4       | After 1 hour                  |
| 5       | After 24 hours                |

## Receiving webhooks

Run `receiver.js` to give an example how to handle webhook requests. First, clone our repository to get the code locally.

`git clone https://gitlab.weseedo.nl/tools/weseedo-webhooks.git`

### Node

Run `receiver.js` manually.

1. Make sure NodeJS is installed on the computer. For more information go to [https://nodejs.org](https://nodejs.org).
2. Install required packages: `npm install`
3. Start the receiver: `node receiver.js`
4. Open a browser and navigate to [http://localhost:9999](http://localhost:9999).
5. The message "Welcome! I am ready to receive!" will be displayed.
6. Watch console logs for incoming data.

### Docker

Mount a docker image to run `receiver.js` locally in your test environment. 

1. Run the docker image: `docker-compose up`
2. Open a browser and navigate to [http://localhost:9999](http://localhost:9999). 
3. The message "Welcome! I am ready to receive!" will be displayed.
4. Watch console logs for incoming data.

## Example data

### Meeting events (direct)

```
{
  "id": "26edf51b5ed353431566fdf1",
  "created": "2020-07-15T12:33:14.000Z",
  "attempt": 1,
  "type": "MEETING_CREATED|MEETING_STARTED|MEETING_RESTARTED|MEETING_ENDED|MEETING_TAKEOVER|MEETING_WAIT|MEETING_DECLINED|MEETING_FORWARDED",
  "data": {
    "id": "6bbf64a9e13844d1d140d6e2",
    "company": {
      "id": "58h6aa8a0e14a4c24df20760",
      "name": "Company 1",
      "contact": {
        "id": "784d061c0856dc4c97774da7",
        "first_name": "Firstname",
        "last_name": "Lastname",
        "email": "contact1@weseedo.nl",
        "phone": "+31612345678",
        "language": "nl"
      }
    },
    "room_id": "9Pusrq3Do43DAEQnOG9aCtLFfl2FoURd",
    "room_password": "O0p48P2TuMavG0EAtMSdpy4PbkO2h2",
    "stream_camera_two_way": true,
    "duration": 0,
    "room_created": "2020-03-27T18:43:07.000Z",
    "room_available_from": "2020-03-27T18:43:07.000Z",
    "room_available_till": "2020-04-03T18:43:07.000Z",
    "created_by": {
      "id": "58f6ee406a2308a38ca39dec",
      "name": "Firstname Lastname"
    },
    "participants": [
      {
        "username": "agent.89f6aa406a2307a38da39a4r",
        "name": "Agent 1",
        "id": "5aedbd02e138231a7c1d7719",
        "user": "58f6ee406a2308a38ca39dec",
        "email": "agent1@weseedo.nl",
        "initial_participant": true,
        "sessions": [
          "sessions"
        ],
        "hash": "qj7OqoxSt2zK6S16my8VZ28N1IigzvNl_jMz42wlA8Dj59DKV0G8zAc6PJ8LvWiHx",
        "url": "https://login-direct.weseedo.nl/meeting/qj7OqoxSt2zK6S16my8VZ28N1IigzvNl_jMz42wlA8Dj59DKV0G8zAc6PJ8LvWiHx"
      },
      {
        "username": "visitor.Cxo9uuYVYFAJDW47",
        "phone": "+3112312312",
        "id": "5aedbd02e138231a7c1d7820",
        "initial_participant": true,
        "sessions": [
          "sessions"
        ],
        "hash": "wCPjvYM7yf7KBwGVU0OsFG6DVBAGqZ5s_6PFMcsoR0GBeKIF8AhkngSqUy9UXBubA",
        "url": "https://login-direct.weseedo.nl/meeting/wCPjvYM7yf7KBwGVU0OsFG6DVBAGqZ5s_6PFMcsoR0GBeKIF8AhkngSqUy9UXBubA"
      }
    ]
  }
}
```

### Meeting events (personal)

```
{
  "id": "26edf51b5ed353431566fdf1",
  "created": "2020-07-15T12:33:14.000Z",
  "attempt": 1,
  "type": "MEETING_CREATED|MEETING_STARTED|MEETING_RESTARTED|MEETING_ENDED|MEETING_CHANGED|MEETING_TAKEN|MEETING_WAIT|MEETING_DECLINED|MEETING_FORWARDED",
  "data": {
    "id": "6bbf64a9e13844d1d140d6e2",
    "company": {
      "id": "58h6aa8a0e14a4c24df20760",
      "name": "Company 1",
      "contact": {
        "id": "784d061c0856dc4c97774da7",
        "first_name": "Firstname",
        "last_name": "Lastname",
        "email": "contact1@weseedo.nl",
        "phone": "+31612345678",
        "language": "nl"
      }
    },
    "room_id": "9Pusrq3Do43DAEQnOG9aCtLFfl2FoURd",
    "room_password": "O0p48P2TuMavG0EAtMSdpy4PbkO2h2",
    "duration": 0,
    "is_appointment": true,
    "room_created": "2020-03-18T14:15:00.000Z",
    "room_available_from": "2020-03-18T14:15:00.000Z",
    "room_available_till": "2020-03-18T15:15:00.000Z",
    "created_by": {
      "id": "58f6ee406a2308a38ca39dec",
      "name": "Firstname Lastname"
    },
    "site": {
      "id": "47c6eedd1a14d3b20dd20771",
      "name": "Account 1"
    },
    "subject": "Meeting",
    "invitation": "Hereby I send you the confirmation for our online video call. On the specified date and time you can click the link in this email. The video call will appear on your screen and we can start the conversation. See you soon!",
    "participants": [
      {
        "username": "agent.89f6aa406a2307a38da39a4r",
        "name": "Agent",
        "id": "5aedbd02e138231a7c1d7719",
        "user": "58f6ee406a2308a38ca39dec",
        "email": "agent1@weseedo.nl",
        "initial_participant": true,
        "sessions": [
          "sessions"
        ],
        "hash": "qj7OqoxSt2zK6S16my8VZ28N1IigzvNl_jMz42wlA8Dj59DKV0G8zAc6PJ8LvWiHx",
        "url": "https://login.weseedo.nl/#/conversation/qj7OqoxSt2zK6S16my8VZ28N1IigzvNl_jMz42wlA8Dj59DKV0G8zAc6PJ8LvWiHx"
      },
      {
        "username": "visitor.Cxo9uuYVYFAJDW47",
        "name": "Participant 1",
        "id": "5aedbd02e138231a7c1d7820",
        "email": "visitor1@participant.nl",
        "phone": "+31612312312",
        "initial_participant": true,
        "sessions": [
          "sessions"
        ],
        "hash": "wCPjvYM7yf7KBwGVU0OsFG6DVBAGqZ5s_6PFMcsoR0GBeKIF8AhkngSqUy9UXBubA",
        "url": "https://login.weseedo.nl/meeting/wCPjvYM7yf7KBwGVU0OsFG6DVBAGqZ5s_6PFMcsoR0GBeKIF8AhkngSqUy9UXBubA"
      },
      {
        "username": "visitor.Cxo9uuYVYFAJDW48",
        "name": "Participant 1",
        "id": "5aedbd02e138231a7c1d7820",
        "email": "visitor2@participant.nl",
        "phone": "+31612312312",
        "initial_participant": true,
        "sessions": [
          "sessions"
        ],
        "hash": "wCPjvYM7yf7KBwGVU0OsFG6DVBAGqZ5s_6PFMcsoR0GBeKIF8AhkngSqUy9UXBubB",
        "url": "https://login.weseedo.nl/meeting/wCPjvYM7yf7KBwGVU0OsFG6DVBAGqZ5s_6PFMcsoR0GBeKIF8AhkngSqUy9UXBubB"
      }
    ]
  }
}
```

### User events

```
{
  "id": "26edf51b5ed353431566fdf1",
  "created": "2020-07-15T12:33:14.000Z",
  "attempt": 1,
  "type": "USER_CREATED|USER_CHANGED",
  "data": {
    "id": "58f6ee406a2308a38ca39dec",
    "first_name": "Firstname",
    "last_name": "Lastname",
    "name": "Firstname Lastname",
    "email": "agent1@weseedo.nl",
    "photo": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAARgAAAAqCAIAA.....",
    "locale": "nl",
    "role": "agent",
    "created_at": "2020-01-29T15:26:20.000Z",
    "sites": [
      {
        "id": "47c6eedd1a14d3b20dd20771",
        "name": "Account 1"
      },
      {
        "id": "47c6eedd1a14d3b20dd20772",
        "name": "Account 2"
      }
    ],
    "entity": {
      "type": "company",
      "id": "58h6aa8a0e14a4c24df20760",
      "name": "WeSeeDo B.V.",
      "package": {
        "id": "674a5rb3ca9d4f7e4f1da67a",
        "name": "professional",
        "features": [
          "agent_create_appointment",
          "send_file",
          "screenshot",
          "chat"
        ]
      }
    },
    "status": "online",
    "suspended": false
  }
}
```

### Site events

```
{
  "id": "26edf51b5ed353431566fdf1",
  "created": "2020-07-15T12:33:14.000Z",
  "attempt": 1,
  "type": "SITE_CREATED|SITE_CHANGED",
  "data": {
    "id": "35h64d8a0e14e4c24ac20f42",
    "name": "Site 1",
    "logo": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAARgAAAAqCAIAA.....",
    "company": {
      "id": "58h6aa8a0e14a4c24df20760",
      "name": "Company 1",
      "contact": {
        "id": "784d061c0856dc4c97774da7",
        "first_name": "Firstname",
        "last_name": "Lastname",
        "email": "contact1@weseedo.nl",
        "phone": "+31612345678",
        "language": "nl"
      }
    },
    "users": [
      {
        "id": "58f6ee406a2308a38ca39dec",
        "first_name": "Firstname",
        "last_name": "Lastname",
        "name": "Firstname Lastname",
        "email": "agent1@weseedo.nl",
        "locale": "nl",
        "role": "agent",
        "created_at": "2020-01-29T15:26:20.000Z",
        "entity": {
          "type": "company",
          "id": "58h6aa8a0e14a4c24df20760",
          "name": "WeSeeDo B.V."
        },
        "suspended": false
      },
      {
        "id": "54c6ae2c7a4504a38ca39dea",
        "first_name": "Firstname",
        "last_name": "Lastname",
        "name": "Firstname Lastname",
        "email": "agent1@weseedo.nl",
        "locale": "nl",
        "role": "agent",
        "created_at": "2020-01-29T15:26:20.000Z",
        "entity": {
          "type": "company",
          "id": "58h6aa8a0e14a4c24df20760",
          "name": "WeSeeDo B.V."
        },
        "suspended": false
      }
    ],
    "videochat_font_type": "Roboto",
    "videochat_text_color": "#000000",
    "email_invite_text": "Hereby I send you the confirmation for our online video call. On the specified date and time you can click the link in this email. The video call will appear on your screen and we can start the conversation. See you soon!",
    "email_cancel_text": "In case of a rescheduled appointment you will receive a new invitation by email. In this case you can discard the email regarding the old invitation.",
    "email_hardwaretest_text": "Using the link below you can test if your hardware is suitable for using WeSeeDo.",
    "email_enable_hardwaretest": false,
    "webhook_url": "https://myserver.com/send/webhook/here"
  }
}
```

### Company events

```
{
  "id": "26edf51b5ed353431566fde1",
  "created": "2020-07-15T12:33:14.000Z",
  "attempt": 1,
  "type": "COMPANY_CREATED|COMPANY_CHANGED",
  "data": {
    "id": "58h6aa8a0e14a4c24df20760",
    "name": "Company 1",
    "contact": {
      "id": "784d061c0856dc4c97774da7",
      "first_name": "Firstname",
      "last_name": "Lastname",
      "email": "contact1@weseedo.nl",
      "phone": "+31612345678",
      "language": "nl"
    },
    "package": {
      "id": "674a5rb3ca9d4f7e4f1da67a",
      "name": "professional",
      "features": [
        "agent_create_appointment",
        "send_file",
        "screenshot",
        "chat"
      ]
    },
    "dealer": {
      "id": "674d071c1854dd4c97774aa8",
      "name": "Dealer 1",
      "contact": {
        "id": "384c061c0956dc4c98874ba8",
        "first_name": "Firstname",
        "last_name": "Lastname",
        "email": "dealer1@weseedo.nl",
        "phone": "+31612345678",
        "language": "nl"
      }
    },
    "webhook_url": "https://myserver.com/send/webhook/here",
    "suspended": false
  }
}
```

### Dealer events

```
{
  "id": "26edf51b5ed353431566fdd1",
  "created": "2020-07-15T12:33:14.000Z",
  "attempt": 1,
  "type": "DEALER_CREATED|DEALER_CHANGED",
  "data": {
    "id": "45h6ac8a1e14a3c24ab20740",
    "name": "Dealer 1",
    "contact": {
      "id": "734d161c1456dc4c97774bb7",
      "first_name": "Firstname",
      "last_name": "Lastname",
      "email": "dealer1@weseedo.nl",
      "phone": "+31612345678",
      "language": "nl"
    },
    "notification_contact": {
      "email": "notify_dealer@weseedo.nl"
    },
    "reseller": {
      "id": "334d171d1854dd4c97874ba8",
      "name": "Reseller 1",
      "contact": {
        "id": "444c071c0956db4c986674ba8",
        "first_name": "Firstname",
        "last_name": "Lastname",
        "email": "reseller1@weseedo.nl",
        "phone": "+31612345678",
        "language": "nl"
      }
    },
    "suspended": false
  }
}
```

### Deleted events

```
{
  "id": "26edf51b5ed353431566fdd1",
  "created": "2020-07-15T12:33:14.000Z",
  "attempt": 1,
  "type": "DEALER_DELETED|COMPANY_DELETED|SITE_DELETED|USER_DELETED|MEETING_DELETED",
  "data": {
    "id": "45h6ac8a1e14a3c24ab20740",
  }
}
```
